/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VerticalStackedChartsWithParametricSpirals {
    public VerticalStackedChartsWithParametricSpirals(JPanel panel) {
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(800, 500));
        Chart2D[] charts = new Chart2D[2];
        for (int i = 0; i < 2; ++i) {
            charts[i] = new Chart2D();
            charts[i].setUseAntialiasing(true);
        }
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new ChartPanel(charts[0]));
        panel.add(new ChartPanel(charts[1]));
        Trace2DSimple trace = new Trace2DSimple();
        charts[0].addTrace(trace);
        for (int i = 0; i < 10000; ++i) {
            double t = (double)i / 10000.0;
            trace.addPoint(t * Math.cos(t * 20.0 * Math.PI), t * Math.sin(t * 20.0 * Math.PI));
        }
        Trace2DSimple trace2 = new Trace2DSimple();
        Trace2DSimple trace3 = new Trace2DSimple();
        charts[1].addTrace(trace2);
        charts[1].addTrace(trace3);
        double ay = 1.0;
        for (int i = 0; i < 10000; ++i) {
            double t = (double)i / 10000.0;
            trace2.addPoint(Math.cos(t * 2.0 * Math.PI) + 0.2 * Math.cos(t * 20.0 * Math.PI), 1.0 * (Math.sin(t * 2.0 * Math.PI) + 0.2 * Math.sin(t * 20.0 * Math.PI)));
            trace3.addPoint(Math.cos(t * 2.0 * Math.PI) - 0.2 * Math.cos(t * 20.0 * Math.PI), 1.0 * (Math.sin(t * 2.0 * Math.PI) - 0.2 * Math.sin(t * 20.0 * Math.PI)));
        }
        trace3.setColor(Color.RED);
        trace3.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Vertical stacked chart");
        JPanel panel = new JPanel();
        frame.setContentPane(panel);
        new VerticalStackedChartsWithParametricSpirals(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

