/*
 * Copyright (C) 2011-2024 Michael Lugmair
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Common/SayonaraTest.h"
#include "Components/Covers/Fetcher/Audioscrobbler.h"

// access working directory with Test::Base::tempPath("somefile.txt");

class AudioscrobblerTest :
	public Test::Base
{
	Q_OBJECT

	public:
		AudioscrobblerTest() :
			Test::Base("AudioscrobblerTest") {}

	private slots:

		// NOLINTNEXTLINE(readability-convert-member-functions-to-static)
		[[maybe_unused]] void testAlbumAnswer()
		{
			const auto data = getAlbumSample();
			const auto fetcher = Cover::Fetcher::Audioscrobbler();
			const auto addresses = fetcher.parseAddresses(data);
			const auto expected = QStringList {
				"https://lastfm.freetls.fastly.net/i/u/300x300/2adc3b653c5465d560b2d8cb95d8a974.jpg",
				"https://lastfm.freetls.fastly.net/i/u/174s/2adc3b653c5465d560b2d8cb95d8a974.jpg",
				"https://lastfm.freetls.fastly.net/i/u/64s/2adc3b653c5465d560b2d8cb95d8a974.jpg",
				"https://lastfm.freetls.fastly.net/i/u/34s/2adc3b653c5465d560b2d8cb95d8a974.jpg"
			};

			QVERIFY(addresses == expected);
		}

	private:
		static QByteArray getAlbumSample();
};

// this has to be so ugly because moc compiler does not like raw string literals in anonymous namespaces
QByteArray AudioscrobblerTest::getAlbumSample()
{
	return R"(
{"album":{"artist":"Metallica","mbid":"05678d96-23f6-4dae-b994-53c3ff4dede0","tags":{"tag":[{"url":"https:\/\/www.last.fm\/tag\/heavy+metal","name":"heavy metal"},{"url":"https:\/\/www.last.fm\/tag\/metal","name":"metal"},{"url":"https:\/\/www.last.fm\/tag\/thrash+metal","name":"thrash metal"},{"url":"https:\/\/www.last.fm\/tag\/metallica","name":"metallica"},{"url":"https:\/\/www.last.fm\/tag\/rock","name":"rock"}]},"playcount":"42408102","image":[{"size":"small","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/34s\/2adc3b653c5465d560b2d8cb95d8a974.jpg"},{"size":"medium","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/64s\/2adc3b653c5465d560b2d8cb95d8a974.jpg"},{"size":"large","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/174s\/2adc3b653c5465d560b2d8cb95d8a974.jpg"},{"size":"extralarge","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/300x300\/2adc3b653c5465d560b2d8cb95d8a974.jpg"},{"size":"mega","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/300x300\/2adc3b653c5465d560b2d8cb95d8a974.jpg"},{"size":"","#text":"https:\/\/lastfm.freetls.fastly.net\/i\/u\/300x300\/2adc3b653c5465d560b2d8cb95d8a974.jpg"}],"tracks":{"track":[{"streamable":{"fulltrack":"0","#text":"0"},"duration":331,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Enter+Sandman","name":"Enter Sandman","@attr":{"rank":1},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":324,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Sad+but+True","name":"Sad but True","@attr":{"rank":2},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":227,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Holier+Than+Thou","name":"Holier Than Thou","@attr":{"rank":3},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":387,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/The+Unforgiven","name":"The Unforgiven","@attr":{"rank":4},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":390,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Wherever+I+May+Roam","name":"Wherever I May Roam","@attr":{"rank":5},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":240,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Don%27t+Tread+on+Me","name":"Don't Tread on Me","@attr":{"rank":6},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":244,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Through+the+Never","name":"Through the Never","@attr":{"rank":7},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":389,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Nothing+Else+Matters","name":"Nothing Else Matters","@attr":{"rank":8},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":256,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/Of+Wolf+and+Man","name":"Of Wolf and Man","@attr":{"rank":9},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":346,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/The+God+That+Failed","name":"The God That Failed","@attr":{"rank":10},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":490,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/My+Friend+of+Misery","name":"My Friend of Misery","@attr":{"rank":11},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}},{"streamable":{"fulltrack":"0","#text":"0"},"duration":398,"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica\/The+Struggle+Within","name":"The Struggle Within","@attr":{"rank":12},"artist":{"url":"https:\/\/www.last.fm\/music\/Metallica","name":"Metallica","mbid":"65f4f0c5-ef9e-490c-aee3-909e7ae6b2ab"}}]},"url":"https:\/\/www.last.fm\/music\/Metallica\/Metallica","name":"Metallica","listeners":"1836259","wiki":{"published":"05 May 2019, 22:36","summary":"Metallica (also known as The Black Album) is the fifth studio album by the American heavy metal band Metallica, released August 12, 1991 through Elektra Records. It features some of Metallica's most popular songs, \"Enter Sandman\", \"The Unforgiven\", \"Nothing Else Matters\" , \"Wherever I May Roam\" and \"Sad but True\". It spent four consecutive weeks at number one on Billboard 200. Metallica is the band's best-selling album to date, with over 16 million physical copies sold in the United States and over 31 million copies worldwide. It is the best-selling album of the SoundScan era. The album cover features only <a href=\"https:\/\/www.last.fm\/music\/Metallica\/Metallica\">Read more on Last.fm<\/a>.","content":"Metallica (also known as The Black Album) is the fifth studio album by the American heavy metal band Metallica, released August 12, 1991 through Elektra Records. It features some of Metallica's most popular songs, \"Enter Sandman\", \"The Unforgiven\", \"Nothing Else Matters\" , \"Wherever I May Roam\" and \"Sad but True\". It spent four consecutive weeks at number one on Billboard 200. Metallica is the band's best-selling album to date, with over 16 million physical copies sold in the United States and over 31 million copies worldwide. It is the best-selling album of the SoundScan era.\n\nThe album cover features only the band's logo, angled against the upper left corner, and a coiled snake (derived from the Gadsden flag) on the bottom right corner, both in a dark shade of gray in order to be made out against the black background. The motto of the Gadsden flag, \"Don't Tread on Me\", is also the title of a song featured on the album.\n\nThe cover is very reminiscent of Spinal Tap's Smell the Glove album, something the band jokingly acknowledged themselves in their A Year and a Half in the Life of Metallica documentary (where members of Spinal Tap appeared and asked them about it).\n\nMetallica DVD-Audio 5.1 mix was released in 2004 through Elektra Records.\n\nWhile the album and the band were critically praised and commercially successful, some fans expressed disappointment in the new direction taken by Metallica. Gone for the most part were faster staccato riffs during verses and throaty vocals found on the band's first four albums; the overall speed and complexity of the music was somewhat lessened. The Black Album presented a more radio-friendly, commercially accessible Metallica, especially evidenced by the ballad \"Nothing Else Matters\". Moreover, following the success of \"One,\" the breakaway single from their …And Justice for All album, five videos were released from The Black Album. (\"Enter Sandman\", \"Nothing Else Matters\", \"Sad but True\", \"Wherever I May Roam\" and \"The Unforgiven\").\n\nThe lyrics of The Black Album, written by James Hetfield, were much more personal and introspective in nature than previous Metallica albums. For example, \"The God That Failed\" dealt with Hetfield's mother's death from cancer and her Christian Science beliefs which kept her from seeking medical treatment. \"Nothing Else Matters\" expresses the connection Hetfield felt with a girlfriend while out on the road. The album ended Metallica's tradition of including a lengthy instrumental track on each album until their 2008 album Death Magnetic.\n\n    * Rolling Stone (9\/5\/91) - 5 Stars — Excellent — Included in Rolling Stone's \"Essential Recordings of the 90's\" - \"Several songs...seem destined to become hard-rock classics.... effectively bridg the gap between commercial metal and the much harder thrash of Slayer, Anthrax and Megadeth.\" In 2003, the album was ranked number 252 on Rolling Stone magazine's list of the 500 greatest albums of all time.\n\n    * Spin (9\/99, p.146) - Ranked #52 in Spin Magazine's \"90 Greatest Albums of the '90s\" - Spin (p.89) - \"This record's diamond-tipped tuneage stripped the band's melancholy guitar excess down to melodic, radio-ready bullets and ballads.\"\n\n    * Entertainment Weekly (8\/16\/91) - \"Rock's preeminent speed-metal cyclone...Metallica may have invented a new genre: progressive thrash.\" - Rating: B+\n\n    * Q magazine (8\/00, p.127) - Included in Q's \"Best Metal Albums of All Time\" - \"Transformed them from cult metal heroes into global superstars....bringing a little refinement to their undoubted power.\"\n\n    * Melody Maker (12\/91) - Ranked #16 in Melody Maker's list of the top 30 albums of 1991 - \"In a committed move away from their thrash roots, Metallica was slower, less complicated, and probably twice as heavy as anything they'd done before.\"\n\n\nMetallica was produced by Bob Rock, who was originally asked to mix the album as the band was impressed with his work as producer on the Mötley Crüe album, Dr. Feelgood. Initially, the band was not interested in having Rock produce their album, but changed their minds as Ulrich stated; \"We felt that we still had our best record in us and Bob  could help us make it.\" The Black Album's sound was a marked difference from the stripped down production of the previous album. Rock altered the band's working schedule and routine so much that they swore never to work with him again. The animosity and tension between band and producer was documented in the documentaries A Year And A Half In The Life of Metallica and Classic Albums: The Black Album. Both explore and document the intense and merciless recording process that resulted in The Black Album.\n\nDespite the controversies between the band and Rock, he continued to work with the band up until, and including, the 2003 album St. Anger.\n\nThe world tour following the Metallica album, initially dubbed the \"Wherever We May Roam Tour\" and then later the \"Nowhere Else To Roam Tour\", saw Metallica on the road for the next three years. The tour was in part documented in the A Year and a Half in the Life of Metallica documentary, as well as the 3-CD, 2-DVD (or 3-VHS) boxset Live Shit: Binge & Purge. <a href=\"https:\/\/www.last.fm\/music\/Metallica\/Metallica\">Read more on Last.fm<\/a>. User-contributed text is available under the Creative Commons By-SA License; additional terms may apply."}}}
)";
}

QTEST_GUILESS_MAIN(AudioscrobblerTest)

#include "AudioscrobblerTest.moc"
