// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: jflex/scilab.jflex

//CHECKSTYLE:OFF

package org.scilab.modules.helptools.scilab;

import java.util.Arrays;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;

@javax.annotation.Generated("JFlex")

// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
public final class ScilabLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int QSTRING = 2;
  public static final int COMMENT = 4;
  public static final int FIELD = 6;
  public static final int COMMANDS = 8;
  public static final int COMMANDSWHITE = 10;
  public static final int BREAKSTRING = 12;
  public static final int FUNCTION = 14;
  public static final int TYPEID = 16;
  public static final int FUNNAME = 18;
  public static final int RETS = 20;
  public static final int ARGS = 22;
  public static final int BREAKINARGS = 24;
  public static final int WHITESEOL = 26;
  public static final int CLEANFIRST = 28;
  public static final int CLEAN = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\37\u0100\1\u0200\267\u0100\10\u0300\u1020\u0100";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\1\0\10\1\1\2\1\3\2\4\1\5\22\1\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\21\1\23\1\24\12\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\7\1\33\2\11"+
    "\1\34\1\35\1\36\1\37\1\11\1\40\1\41\3\11"+
    "\1\42\1\11\1\43\1\44\1\11\1\45\1\46\1\47"+
    "\2\11\1\50\3\11\1\51\1\52\1\53\1\54\1\7"+
    "\1\1\1\55\1\56\1\57\1\60\1\61\1\62\1\11"+
    "\1\63\1\64\1\11\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\74\1\75\1\76\1\77\1\11\1\100"+
    "\1\101\1\102\1\37\1\103\1\104\1\105\1\33\6\1"+
    "\1\4\u01a2\1\2\4\326\1\u0100\4";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[1024];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\2\0\1\1\12\0\1\3\1\4"+
    "\1\5\2\6\1\7\1\10\1\11\1\12\1\10\1\13"+
    "\1\14\1\15\1\16\2\17\1\20\1\17\1\21\1\12"+
    "\1\22\1\17\1\23\20\10\2\1\1\24\1\25\1\26"+
    "\1\1\1\27\1\30\1\2\1\31\1\2\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\37\1\41\1\42"+
    "\1\43\1\1\1\44\1\45\1\1\1\46\2\47\2\46"+
    "\1\37\1\50\1\37\1\51\1\52\1\53\1\37\1\54"+
    "\1\52\1\55\1\37\1\56\1\37\1\52\1\57\1\37"+
    "\1\60\1\37\1\61\1\62\1\63\1\64\1\37\1\65"+
    "\2\37\2\66\1\45\1\37\2\67\1\70\1\52\1\71"+
    "\1\72\1\73\3\74\2\10\1\0\1\75\1\17\1\12"+
    "\1\17\1\21\1\76\1\21\1\77\1\100\1\101\7\10"+
    "\1\102\13\10\4\0\1\103\2\0\1\104\3\0\1\105"+
    "\1\0\1\106\3\10\1\21\1\74\10\10\1\102\10\10"+
    "\1\0\2\107\1\0\1\110\5\10\1\102\1\10\1\111"+
    "\25\10\1\112\1\113\1\10\1\114";

  private static int [] zzUnpackAction() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\106\0\214\0\322\0\u0118\0\u015e\0\u01a4\0\u01ea"+
    "\0\u0230\0\u0276\0\u02bc\0\u0302\0\u0348\0\u038e\0\u03d4\0\u041a"+
    "\0\u0460\0\u0460\0\u0460\0\u0460\0\u04a6\0\u0460\0\u04ec\0\u0460"+
    "\0\u04ec\0\u0532\0\u0578\0\u0460\0\u0460\0\u0460\0\u05be\0\u0460"+
    "\0\u0604\0\u064a\0\u0690\0\u0460\0\u06d6\0\u071c\0\u0762\0\u07a8"+
    "\0\u07ee\0\u0834\0\u087a\0\u08c0\0\u0906\0\u094c\0\u0992\0\u09d8"+
    "\0\u0a1e\0\u0a64\0\u0aaa\0\u0af0\0\u0b36\0\u0b7c\0\u0bc2\0\u0c08"+
    "\0\u0460\0\u0c4e\0\u0460\0\u0c4e\0\u0c94\0\u0460\0\u0460\0\u0cda"+
    "\0\u0460\0\u0d20\0\u0460\0\u0460\0\u0460\0\u0460\0\u0460\0\u0460"+
    "\0\u0d66\0\u0d66\0\u0dac\0\u0dac\0\u0460\0\u0df2\0\u0460\0\u0460"+
    "\0\u0e38\0\u0460\0\u0460\0\u0e7e\0\u0ec4\0\u0f0a\0\u0f50\0\u0f96"+
    "\0\u0f96\0\u0460\0\u0fdc\0\u0460\0\u1022\0\u0460\0\u1068\0\u10ae"+
    "\0\u10ae\0\u0460\0\u10f4\0\u113a\0\u1180\0\u1180\0\u0460\0\u11c6"+
    "\0\u0460\0\u0460\0\u0460\0\u120c\0\u120c\0\u0460\0\u1252\0\u1298"+
    "\0\u0460\0\u12de\0\u1298\0\u1324\0\u0460\0\u136a\0\u13b0\0\u13f6"+
    "\0\u0460\0\u143c\0\u1482\0\u04ec\0\u14c8\0\u150e\0\u1554\0\u159a"+
    "\0\u0578\0\u0460\0\u15e0\0\u1626\0\u166c\0\u16b2\0\u0460\0\u16f8"+
    "\0\u0460\0\u0460\0\u0460\0\u173e\0\u1784\0\u17ca\0\u1810\0\u1856"+
    "\0\u189c\0\u18e2\0\u04ec\0\u1928\0\u196e\0\u19b4\0\u19fa\0\u1a40"+
    "\0\u1a86\0\u1acc\0\u1b12\0\u1b58\0\u1b9e\0\u1be4\0\u0c4e\0\u1c2a"+
    "\0\u1c70\0\u0dac\0\u0ec4\0\u0fdc\0\u1022\0\u0460\0\u1068\0\u10f4"+
    "\0\u1cb6\0\u1252\0\u1298\0\u0460\0\u1cfc\0\u1d42\0\u1d88\0\u1dce"+
    "\0\u1e14\0\u1e5a\0\u1ea0\0\u1ee6\0\u1f2c\0\u1f72\0\u1fb8\0\u1ffe"+
    "\0\u2044\0\u208a\0\u20d0\0\u2116\0\u215c\0\u21a2\0\u21e8\0\u222e"+
    "\0\u2274\0\u22ba\0\u2300\0\u0460\0\u2346\0\u238c\0\u0460\0\u23d2"+
    "\0\u2418\0\u245e\0\u24a4\0\u24ea\0\u2530\0\u2576\0\u04ec\0\u25bc"+
    "\0\u2602\0\u2648\0\u268e\0\u26d4\0\u271a\0\u2760\0\u27a6\0\u27ec"+
    "\0\u2832\0\u2878\0\u28be\0\u2904\0\u294a\0\u2990\0\u29d6\0\u2a1c"+
    "\0\u2a62\0\u2aa8\0\u2aee\0\u2b34\0\u2b7a\0\u0460\0\u2bc0\0\u04ec";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\21\1\22\1\23\1\24\1\0\1\25\1\26\1\27"+
    "\1\30\1\27\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\22\1\41\1\42\1\43\1\44\1\22"+
    "\1\45\1\46\1\47\1\46\12\27\1\50\1\51\1\52"+
    "\1\35\1\40\1\36\1\40\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\1\27\1\61\5\27\1\62\1\63\1\64"+
    "\1\65\1\66\1\27\1\67\2\27\1\35\1\40\1\36"+
    "\2\70\1\71\1\24\1\70\1\25\2\70\1\72\3\70"+
    "\1\73\1\74\5\70\1\75\4\70\1\76\1\70\1\77"+
    "\53\70\1\21\2\100\1\101\1\100\1\102\2\100\1\103"+
    "\3\100\1\104\1\105\12\100\1\106\1\100\1\107\53\100"+
    "\3\110\1\24\1\0\1\25\1\110\1\111\1\110\1\111"+
    "\1\112\1\111\20\110\15\111\4\110\26\111\5\110\1\113"+
    "\1\24\1\0\1\25\1\114\7\110\1\115\67\110\2\116"+
    "\1\117\1\24\1\116\1\25\1\120\5\116\1\73\5\116"+
    "\1\110\1\116\1\121\2\116\1\110\1\76\1\116\1\77"+
    "\53\116\2\122\1\117\1\123\1\0\1\124\1\120\14\122"+
    "\1\125\1\126\61\122\4\110\1\0\1\127\1\110\1\130"+
    "\1\110\1\130\1\131\1\130\20\110\15\130\1\132\3\110"+
    "\26\130\5\110\1\133\1\110\1\0\1\127\1\133\7\110"+
    "\1\134\5\110\1\135\4\110\1\136\56\110\1\137\1\110"+
    "\1\0\1\127\1\137\1\140\1\110\1\140\1\141\1\140"+
    "\2\110\1\142\5\110\1\143\7\110\15\140\4\110\26\140"+
    "\5\110\1\144\1\110\1\0\1\127\1\144\1\145\1\110"+
    "\1\145\1\146\1\145\6\110\1\147\1\150\5\110\1\151"+
    "\2\110\15\145\1\152\1\110\1\153\1\110\26\145\5\110"+
    "\1\144\1\110\1\0\1\127\1\144\1\154\1\110\1\154"+
    "\1\155\1\154\3\110\1\156\2\110\1\147\1\157\10\110"+
    "\15\154\4\110\26\154\5\110\1\160\1\161\1\0\1\162"+
    "\1\163\15\110\1\164\61\110\4\165\1\0\1\166\1\120"+
    "\77\165\2\110\1\167\1\170\1\0\1\170\1\167\77\110"+
    "\2\171\1\172\1\173\1\0\1\173\1\172\77\171\111\0"+
    "\1\24\111\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\26\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\3\27\1\174\7\27\1\174\1\27\4\0"+
    "\4\27\1\175\1\174\1\27\1\176\3\27\1\177\1\27"+
    "\1\200\2\27\2\174\4\27\14\0\1\201\13\0\1\201"+
    "\1\0\1\22\4\0\15\201\4\0\26\201\23\0\1\40"+
    "\102\0\1\202\2\0\1\203\2\0\1\204\1\205\1\206"+
    "\24\0\1\205\1\0\1\40\54\0\1\40\1\207\104\0"+
    "\1\206\1\0\1\43\7\0\2\210\21\0\2\210\55\0"+
    "\1\211\1\212\104\0\1\40\105\0\1\213\63\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\1\214\14\27\4\0"+
    "\26\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\6\27\1\215\6\27\4\0\26\27\12\0\1\27\1\0"+
    "\2\27\12\0\1\27\6\0\12\27\1\216\2\27\4\0"+
    "\26\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\1\27\1\217\24\27\12\0\1\27\1\0"+
    "\2\27\12\0\1\27\6\0\15\27\4\0\17\27\1\220"+
    "\6\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\1\221\13\27\1\222\11\27\12\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\4\0\14\27"+
    "\1\223\11\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\11\27\1\224\1\27\1\225\10\27"+
    "\1\226\1\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\14\27\1\227\5\27\1\230\3\27"+
    "\12\0\1\27\1\0\2\27\12\0\1\27\6\0\15\27"+
    "\4\0\5\27\1\223\20\27\12\0\1\27\1\0\2\27"+
    "\12\0\1\27\6\0\15\27\4\0\1\231\25\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\22\27\1\226\3\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\4\27\1\232\21\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\4\27\1\233\21\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\6\27\1\234\10\27\1\235"+
    "\6\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\6\27\1\236\17\27\3\0\2\70\2\0"+
    "\1\70\1\0\2\70\1\237\3\70\1\0\1\237\5\70"+
    "\1\240\4\70\1\0\1\70\1\0\53\70\10\0\1\70"+
    "\4\0\1\70\70\0\2\70\2\0\1\70\1\0\2\70"+
    "\1\0\3\70\2\0\5\70\1\241\4\70\1\0\1\70"+
    "\1\0\53\70\1\0\2\100\1\0\4\100\1\0\3\100"+
    "\2\0\12\100\1\0\1\100\1\0\53\100\1\0\2\100"+
    "\1\101\4\100\1\0\3\100\2\0\12\100\1\0\1\100"+
    "\1\0\53\100\7\0\1\111\1\0\2\111\12\0\1\111"+
    "\6\0\15\111\4\0\26\111\5\0\1\242\3\0\1\242"+
    "\7\0\1\115\67\0\2\116\2\0\1\116\2\0\5\116"+
    "\1\0\5\116\1\0\1\116\1\0\2\116\2\0\1\116"+
    "\1\0\55\116\2\0\1\116\2\0\5\116\1\0\5\116"+
    "\1\0\1\116\1\207\2\116\2\0\1\116\1\0\53\116"+
    "\3\0\1\123\125\0\1\243\106\0\1\207\64\0\1\110"+
    "\111\0\1\130\1\0\2\130\12\0\1\130\6\0\15\130"+
    "\4\0\26\130\5\0\1\244\3\0\1\244\15\0\1\245"+
    "\105\0\1\246\63\0\1\247\3\0\1\247\15\0\1\250"+
    "\70\0\1\140\1\0\2\140\12\0\1\140\6\0\15\140"+
    "\4\0\26\140\27\0\1\115\63\0\1\144\3\0\1\144"+
    "\106\0\1\145\1\0\2\145\12\0\1\145\6\0\15\145"+
    "\4\0\26\145\26\0\1\251\71\0\1\154\1\0\2\154"+
    "\12\0\1\154\6\0\15\154\4\0\26\154\26\0\1\252"+
    "\64\0\1\253\1\161\1\0\1\162\1\253\102\0\1\161"+
    "\126\0\1\254\64\0\1\165\104\0\1\167\1\170\1\0"+
    "\1\170\1\167\102\0\1\170\1\0\1\170\102\0\1\172"+
    "\3\0\1\172\102\0\1\173\1\0\1\173\107\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\4\0\15\27"+
    "\1\255\10\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\13\27\1\256\12\27\12\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\4\0\1\257"+
    "\25\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\7\27\1\174\16\27\23\0\1\40\2\0"+
    "\1\40\105\0\1\204\105\0\1\40\107\0\1\206\7\0"+
    "\2\210\21\0\2\210\45\0\1\260\3\0\1\260\67\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\5\27\1\261"+
    "\7\27\4\0\26\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\10\27\1\262\4\27\4\0\26\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\1\263\14\27"+
    "\4\0\26\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\14\27\1\264\11\27\12\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\4\0\4\27"+
    "\1\265\21\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\20\27\1\266\1\267\4\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\13\27\1\270\12\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\20\27\1\271\5\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\3\27\1\272\22\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\7\27\1\273\16\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\17\27\1\223\6\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\13\27\1\274\12\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\22\27\1\275\3\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\20\27\1\276\1\277\4\27"+
    "\12\0\1\27\1\0\2\27\12\0\1\27\6\0\15\27"+
    "\4\0\11\27\1\300\14\27\12\0\1\27\1\0\2\27"+
    "\12\0\1\27\6\0\15\27\4\0\4\27\1\301\21\27"+
    "\12\0\1\27\1\0\2\27\12\0\1\27\6\0\15\27"+
    "\4\0\25\27\1\223\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\7\27\1\302\16\27\3\0"+
    "\2\70\2\0\1\70\1\0\2\70\1\0\3\70\2\0"+
    "\5\70\1\0\4\70\1\0\1\70\1\0\53\70\2\0"+
    "\1\303\1\304\1\0\1\305\1\303\14\0\1\241\1\306"+
    "\104\0\1\307\71\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\20\27\1\174\5\27\12\0\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\4\0\5\27"+
    "\1\174\20\27\12\0\1\27\1\0\2\27\12\0\1\27"+
    "\6\0\15\27\4\0\13\27\1\174\12\27\30\0\1\260"+
    "\67\0\1\27\1\0\2\27\12\0\1\27\6\0\4\27"+
    "\1\310\10\27\4\0\26\27\12\0\1\27\1\0\2\27"+
    "\12\0\1\27\6\0\1\27\1\311\13\27\4\0\26\27"+
    "\12\0\1\27\1\0\2\27\12\0\1\27\6\0\5\27"+
    "\1\174\7\27\4\0\26\27\12\0\1\27\1\0\2\27"+
    "\12\0\1\27\6\0\15\27\4\0\17\27\1\273\6\27"+
    "\12\0\1\27\1\0\2\27\12\0\1\27\6\0\15\27"+
    "\4\0\1\312\25\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\4\27\1\223\21\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\2\27\1\313\23\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\21\27\1\314\4\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\4\27\1\315\21\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\5\27\1\316\20\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\21\27\1\317\4\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\2\27\1\320\23\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\20\27\1\321\5\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\22\27\1\322\3\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\22\27\1\323\3\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\4\27\1\324\21\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\13\27\1\223\12\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\11\27\1\266\14\27\5\0"+
    "\1\303\1\304\1\0\1\305\1\303\15\0\1\306\64\0"+
    "\1\304\126\0\1\304\70\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\7\27\1\325\5\27\4\0\26\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\5\27\1\326"+
    "\7\27\4\0\26\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\10\27\1\317\15\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\6\27\1\223\17\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\7\27\1\327\16\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\7\27\1\61\16\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\22\27\1\330\3\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\21\27\1\331\4\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\4\27\1\317\21\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\12\27\1\321\13\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\17\27\1\332\6\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\2\27\1\333\23\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\6\27\1\334\6\27\4\0\26\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\11\27\1\174"+
    "\3\27\4\0\26\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\13\27\1\335\12\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\13\27\1\336\12\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\7\27\1\337\16\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\13\27\1\317\12\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\21\27\1\223\4\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\2\27\1\174"+
    "\12\27\4\0\26\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\22\27\1\321\3\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\2\27\1\340\23\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\14\27\1\341\11\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\21\27\1\342\4\27\12\0\1\27\1\0\2\27\12\0"+
    "\1\27\6\0\15\27\4\0\13\27\1\343\12\27\12\0"+
    "\1\27\1\0\2\27\12\0\1\27\6\0\15\27\4\0"+
    "\7\27\1\344\16\27\5\0\1\345\3\0\1\345\1\27"+
    "\1\0\2\27\12\0\1\27\6\0\15\27\1\346\3\0"+
    "\26\27\12\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\14\27\1\347\11\27\5\0\1\345\3\0"+
    "\1\345\106\0\1\27\1\0\2\27\12\0\1\27\6\0"+
    "\15\27\4\0\13\27\1\350\12\27\3\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11270];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\1\2\0\1\1\12\0\4\11\1\1\1\11"+
    "\1\1\1\11\3\1\3\11\1\1\1\11\3\1\1\11"+
    "\24\1\1\11\1\1\1\11\2\1\2\11\1\1\1\11"+
    "\1\1\6\11\4\1\1\11\1\1\2\11\1\1\2\11"+
    "\6\1\1\11\1\1\1\11\1\1\1\11\3\1\1\11"+
    "\4\1\1\11\1\1\3\11\2\1\1\11\2\1\1\11"+
    "\3\1\1\11\3\1\1\11\7\1\1\0\1\11\4\1"+
    "\1\11\1\1\3\11\23\1\4\0\1\1\2\0\1\11"+
    "\3\0\1\1\1\0\1\11\26\1\1\0\1\11\1\1"+
    "\1\0\1\11\36\1\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
    private static Set<String> commands;
    private static Set<String> macros;

    private int beginString;
    private boolean transposable;
    private boolean breakstring;
    private boolean breakargs;
    private int whitesOnFirstLine;
    private int saveLexState;

    private String id;
    private List<String> returnValues = new ArrayList<String>();
    private List<String> argsValues = new ArrayList<String>();
    private List<String> localFun = new ArrayList<String>();

    private AbstractScilabCodeHandler handler;

    public ScilabLexer(String[] primFile, String[] macroFile) {
       if (commands == null) {
          commands = new HashSet<String>();
          macros = new HashSet<String>();
          loadNames(primFile, commands);
          loadNames(macroFile, macros);
       }
    }

    public ScilabLexer(String primFile, String macroFile) {
       this(new String[]{primFile}, new String[]{macroFile});
    }

    public ScilabLexer(Set<String> primitives, Set<String> macros) {
       commands = primitives;
       this.macros = macros;
    }

    private void loadNames(String[] files, Set<String> set) {
       for (int i = 0; i < files.length; i++) {
          loadNames(files[i], set);
       }
    }

    private void loadNames(String file, Set<String> set) {
       if (file == null) {
          return;
       }
       BufferedReader input = null;
       try {
          input = new BufferedReader(new FileReader(file));
          String line = null;
          while ((line = input.readLine()) != null) {
             set.add(line);
          }
       } catch (IOException e) {
          System.err.println(e);
       }
       if (input != null) {
          try {
             input.close();
          } catch (IOException e) {
             System.err.println(e);
          }
       }
    }

    private String trimEnd(String str) {
        int end = str.length() - 1;
        int i = end;
        for (; i >= 0; i--) {
           char c = str.charAt(i);
           if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
              break;
           }
        }
        if (i != end) {
           return str.substring(0, i + 1);
        }

        return str;
    }

    public String convert(AbstractScilabCodeHandler h, String code) {
        Reader reader = new StringReader(trimEnd(code));
        String str = convert(h, reader, true);
        try {
          reader.close();
        } catch (IOException e) { }

        return str;
    }

    public String convert(AbstractScilabCodeHandler h, Reader code, boolean ret) {
        if (code == null) {
           return null;
        } else {
           handler = h;
           transposable = false;
           breakargs = false;
           breakstring = false;
           whitesOnFirstLine = 0;
           localFun.clear();
           yyreset(code);
           yybegin(CLEANFIRST);
           try {
               yylex();
           } catch (IOException e) {
               return null;
           }
           if (ret) {
               return h.toString();
           }
           return "";
        }
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ScilabLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public void yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { handler.handleString(yytext());
            }
            // fall through
          case 77: break;
          case 2:
            { handler.handleComment(yytext());
            }
            // fall through
          case 78: break;
          case 3:
            { return;
            }
            // fall through
          case 79: break;
          case 4:
            { transposable = false;
                                   handler.handleDefault(yytext());
            }
            // fall through
          case 80: break;
          case 5:
            { transposable = false;
                                   handler.handleNothing("    ");
            }
            // fall through
          case 81: break;
          case 6:
            { handler.handleNothing("\n");
                                   saveLexState = YYINITIAL;
                                   yybegin(CLEAN);
            }
            // fall through
          case 82: break;
          case 7:
            { transposable = false;
                                   handler.handleNothing(" ");
            }
            // fall through
          case 83: break;
          case 8:
            { transposable = true;
                                   String str = yytext();
                                   if (commands.contains(str)) {
                                       yybegin(COMMANDS);
                                       handler.handleCommand(str);
                                   } else if (macros.contains(str)) {
                                       yybegin(COMMANDS);
                                       handler.handleMacro(str);
                                   } else if (localFun.contains(str)) {
                                        yybegin(COMMANDS);
                                        handler.handleFunctionId(str);
                                   } else {
                                       if (returnValues.contains(str) || argsValues.contains(str)) {
                                           handler.handleInputOutputArgs(str);
                                       }  else {
                                           handler.handleId(str);
                                       }
                                   }
            }
            // fall through
          case 84: break;
          case 9:
            { transposable = false;
                                   beginString = zzStartRead;
                                   yybegin(QSTRING);
                                   handler.handleString("&#0034;");
            }
            // fall through
          case 85: break;
          case 10:
            { transposable = false;
                                   handler.handleSpecial(yytext());
            }
            // fall through
          case 86: break;
          case 11:
            { transposable = false;
                                   handler.handleOperator("&#0038;");
            }
            // fall through
          case 87: break;
          case 12:
            { if (transposable) {
                                       handler.handleOperator("&#0039;");
                                   } else {
                                       beginString = zzStartRead;
                                       yybegin(QSTRING);
                                       handler.handleString("&#0039;");
                                   }
            }
            // fall through
          case 88: break;
          case 13:
            { transposable = false;
                                   handler.handleOpenClose(yytext());
            }
            // fall through
          case 89: break;
          case 14:
            { transposable = true;
                                   handler.handleOpenClose(yytext());
            }
            // fall through
          case 90: break;
          case 15:
            { transposable = false;
                                   handler.handleOperator(yytext());
            }
            // fall through
          case 91: break;
          case 16:
            { transposable = false;
                                   yybegin(FIELD);
                                   handler.handleOperator(yytext());
            }
            // fall through
          case 92: break;
          case 17:
            { transposable = true;
                                   handler.handleNumber(yytext());
            }
            // fall through
          case 93: break;
          case 18:
            { transposable = false;
                                   handler.handleOperator("&#0060;");
            }
            // fall through
          case 94: break;
          case 19:
            { transposable = false;
                                   handler.handleOperator("&#0062;");
            }
            // fall through
          case 95: break;
          case 20:
            { transposable = false;
                                   yybegin(YYINITIAL);
                                   handler.handleString("&#0034;");
            }
            // fall through
          case 96: break;
          case 21:
            { transposable = false;
                                   handler.handleString("&#0038;");
            }
            // fall through
          case 97: break;
          case 22:
            { transposable = false;
                                   yybegin(YYINITIAL);
                                   handler.handleString("&#0039;");
            }
            // fall through
          case 98: break;
          case 23:
            { transposable = false;
                                   handler.handleString("&#0060;");
            }
            // fall through
          case 99: break;
          case 24:
            { transposable = false;
                                   handler.handleString("&#0062;");
            }
            // fall through
          case 100: break;
          case 25:
            { if (breakstring) {
                                     saveLexState = QSTRING;
                                     breakstring = false;
                                   } else if (breakargs) {
                                     saveLexState = WHITESEOL;
                                     breakargs = false;
                                   } else {
                                     saveLexState = YYINITIAL;
                                   }
                                   handler.handleNothing("\n");
                                   yybegin(CLEAN);
            }
            // fall through
          case 101: break;
          case 26:
            { handler.handleComment("&#0034;");
            }
            // fall through
          case 102: break;
          case 27:
            { handler.handleComment("&#0038;");
            }
            // fall through
          case 103: break;
          case 28:
            { handler.handleComment("&#0039;");
            }
            // fall through
          case 104: break;
          case 29:
            { handler.handleComment("&#0060;");
            }
            // fall through
          case 105: break;
          case 30:
            { handler.handleComment("&#0062;");
            }
            // fall through
          case 106: break;
          case 31:
            { yypushback(1);
                                   yybegin(YYINITIAL);
            }
            // fall through
          case 107: break;
          case 32:
            { handler.handleField(yytext());
            }
            // fall through
          case 108: break;
          case 33:
            { yybegin(COMMANDSWHITE);
                                   handler.handleNothing("    ");
            }
            // fall through
          case 109: break;
          case 34:
            { yybegin(COMMANDSWHITE);
                                   handler.handleNothing(" ");
            }
            // fall through
          case 110: break;
          case 35:
            { yypushback(yylength());
                                   yybegin(YYINITIAL);
            }
            // fall through
          case 111: break;
          case 36:
            { handler.handleNothing("    ");
            }
            // fall through
          case 112: break;
          case 37:
            { handler.handleNothing(" ");
            }
            // fall through
          case 113: break;
          case 38:
            { handler.handleDefault(yytext());
            }
            // fall through
          case 114: break;
          case 39:
            { if (breakstring) {
                                      breakstring = false;
                                      saveLexState = QSTRING;
                                   } else {
                                      saveLexState = YYINITIAL;
                                   }
                                   handler.handleNothing("\n");
                                   yybegin(CLEAN);
            }
            // fall through
          case 115: break;
          case 40:
            { id = yytext();
                                   yybegin(TYPEID);
            }
            // fall through
          case 116: break;
          case 41:
            { handler.handleOpenClose("[");
                                   yybegin(RETS);
            }
            // fall through
          case 117: break;
          case 42:
            { 
            }
            // fall through
          case 118: break;
          case 43:
            { localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
                                   handler.handleOpenClose("(");
                                   yybegin(ARGS);
            }
            // fall through
          case 119: break;
          case 44:
            { returnValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
                                   handler.handleOperator("=");
                                   yybegin(FUNNAME);
            }
            // fall through
          case 120: break;
          case 45:
            { id = yytext();
                                   localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
            }
            // fall through
          case 121: break;
          case 46:
            { handler.handleOpenClose("(");
                                   yybegin(ARGS);
            }
            // fall through
          case 122: break;
          case 47:
            { id = yytext();
                                   returnValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
            }
            // fall through
          case 123: break;
          case 48:
            { handler.handleDefault(", ");
            }
            // fall through
          case 124: break;
          case 49:
            { handler.handleOperator("=");
                                   yybegin(FUNNAME);
            }
            // fall through
          case 125: break;
          case 50:
            { handler.handleOpenClose("[");
            }
            // fall through
          case 126: break;
          case 51:
            { handler.handleOpenClose("]");
            }
            // fall through
          case 127: break;
          case 52:
            { id = yytext();
                                   argsValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
            }
            // fall through
          case 128: break;
          case 53:
            { handler.handleOpenClose(")");
                                   yybegin(YYINITIAL);
            }
            // fall through
          case 129: break;
          case 54:
            { handler.handleNothing("\n");
                                   saveLexState = WHITESEOL;
                                   yybegin(CLEAN);
            }
            // fall through
          case 130: break;
          case 55:
            { yypushback(1);
                                   yybegin(ARGS);
            }
            // fall through
          case 131: break;
          case 56:
            { whitesOnFirstLine = yylength();
                                   yybegin(YYINITIAL);
            }
            // fall through
          case 132: break;
          case 57:
            { yypushback(1);
                                   yybegin(saveLexState);
            }
            // fall through
          case 133: break;
          case 58:
            { int len = yylength() - whitesOnFirstLine;
                                   if (len > 0) {
                                      yypushback(len);
                                   }
                                   yybegin(saveLexState);
            }
            // fall through
          case 134: break;
          case 59:
            { handler.handleNothing("\n");
            }
            // fall through
          case 135: break;
          case 60:
            { transposable = true;
                                   handler.handleConstants(yytext());
            }
            // fall through
          case 136: break;
          case 61:
            { transposable = false;
                                   handler.handleOperator(".&#0039;");
            }
            // fall through
          case 137: break;
          case 62:
            { transposable = false;
                                   yypushback(2);
                                   yybegin(COMMENT);
            }
            // fall through
          case 138: break;
          case 63:
            { transposable = false;
                                   handler.handleOperator("&#0060;=");
            }
            // fall through
          case 139: break;
          case 64:
            { transposable = false;
                                   handler.handleOperator("&#0060;&#0062;");
            }
            // fall through
          case 140: break;
          case 65:
            { transposable = false;
                                   handler.handleOperator("&#0062;=");
            }
            // fall through
          case 141: break;
          case 66:
            { transposable = false;
                                   handler.handleSKeywords(yytext());
            }
            // fall through
          case 142: break;
          case 67:
            { breakstring = true;
                                   handler.handleSpecial(yytext());
            }
            // fall through
          case 143: break;
          case 68:
            { localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
                                   yypushback(yylength());
                                   yybegin(YYINITIAL);
            }
            // fall through
          case 144: break;
          case 69:
            { handler.handleSpecial(yytext());
                                   yybegin(BREAKINARGS);
            }
            // fall through
          case 145: break;
          case 70:
            { breakargs = true;
                                   yypushback(2);
                                   yybegin(COMMENT);
            }
            // fall through
          case 146: break;
          case 71:
            { yypushback(yylength());
                                   yybegin(BREAKSTRING);
                                   transposable = false;
                                   handler.handleString(yytext());
            }
            // fall through
          case 147: break;
          case 72:
            { handler.handleNothing("...");
            }
            // fall through
          case 148: break;
          case 73:
            { transposable = false;
                                   handler.handleCKeywords(yytext());
            }
            // fall through
          case 149: break;
          case 74:
            { transposable = false;
                                   handler.handleFKeywords("function");
                                   handler.handleNothing(" ");
                                   yybegin(FUNCTION);
            }
            // fall through
          case 150: break;
          case 75:
            { transposable = false;
                                   handler.handleFKeywords("function");
                                   handler.handleNothing(" ");
                                   handler.handleOpenClose("[");
                                   yybegin(RETS);
            }
            // fall through
          case 151: break;
          case 76:
            { transposable = false;
                                   returnValues.clear();
                                   argsValues.clear();
                                   handler.handleFKeywords("endfunction");
            }
            // fall through
          case 152: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
