use strict;
#use Test::More tests => 34;
use Test::More qw(no_plan);

use English;
use RoPkg::Exceptions;

use warnings;
use strict;

BEGIN {
  use_ok('RoPkg::Simba');
  use_ok('RoPkg::Simba::Mirror');
}

my ($simba, $mirror);

$simba = new RoPkg::Simba(
    cfgFile => './simba-home.cfg'
    );

eval {
  $mirror = new RoPkg::Simba::Mirror();
};
ok(Exception::Class->caught('Param::Missing'),'new() raises exception');

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => '');
};
ok(Exception::Class->caught('Param::Missing'),'new(dbo => "") raises exception');

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => $simba);
};
ok(Exception::Class->caught('Param::Missing'),'new(dbo => $simba) raises exception');

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => $simba->dbo);
};
ok(Exception::Class->caught('Param::Missing'), 'new(dbo => $simba->dbo) raise exception');

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => $simba->dbo, dbo_method => $simba->dbo_method);
};
ok(!ref($@), 'new(correct parameters) does not raise exceptions');
