// Print out program version; to be passed to the SOptions package.
class VersionOption extends Option {

    static final String progName =
        System.getProperty("sun.java.command").split("[ \t]+")[0];
    
    static final String version = Version.versionString;
    static final String vcstext = Version.vcsText;

    VersionOption( String short_name, String long_name, OptionType opt_type )
    {
        super( short_name, long_name, opt_type );
    }

    int proc( String args[], int i ) {
        System.out.print( progName + " version " + version );
        if( vcstext != null && !vcstext.equals("") ) {
            System.out.print( " " + vcstext );
        }
        System.out.println();
        System.exit(0);
        return i;
    }
}
