#version 460
#extension GL_EXT_ray_tracing : require
#extension GL_EXT_ray_tracing_position_fetch : require

layout(location = 0) rayPayloadInEXT vec3 hitValue;
hitAttributeEXT vec2 attribs;

void main()
{
	const vec3 barycentricCoords = vec3(1.0 - attribs.x - attribs.y, attribs.x, attribs.y);

	vec3 pos0 = gl_HitTriangleVertexPositionsEXT[0];
	vec3 pos1 = gl_HitTriangleVertexPositionsEXT[1];
	vec3 pos2 = gl_HitTriangleVertexPositionsEXT[2];

	hitValue = pos0 * barycentricCoords.x + pos1 * barycentricCoords.y + pos2 * barycentricCoords.z;
}
